<?php

/**
 * Custom coded by Spiderfly Studios https://www.spiderflystudios.com
 * Shortlink
 * Displays a post/page/product edit button.
 */
 
add_action('wp_head','editbtn_style');
function editbtn_style( ){
	if (is_page()){
	echo '<style>.page-id-'.get_the_ID().' .mfp-iframe-holder .mfp-content {max-width: 90% !important;}</style>';
	echo '<style>.page-id-'.get_the_ID().' .mfp-iframe-scaler {padding-top:80% !important;}</style>';	
	}else{
	echo '<style>.postid-'.get_the_ID().' .mfp-wrap .mfp-iframe-holder .mfp-content {max-width: 90% !important; height: 100% !important; padding-top:60px !important; padding-bottom:60px !important;}</style>';
	echo '<style>.postid-'.get_the_ID().' .mfp-iframe-holder .mfp-iframe-scaler {height:100% !important; padding-top:80px !important; padding-bottom: 80px !important;}</style>';
	}
	}

if ( !class_exists( 'avia_editlink' ) )
{
	class avia_editlink extends aviaShortcodeTemplate
	{
		/**
		 * Create the config array for the shortcode button
		 */
		function shortcode_insert_button()
		{
			$template_url = get_stylesheet_directory_uri();
			$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
			$this->config['name']		= __('Edit Link', 'avia_framework' );
			$this->config['tab']		= __('Spiderfly Elements', 'avia_framework' );
			$this->config['icon']		= $child_sc_imgs."edit.png";
			$this->config['order']		= 11;
			$this->config['target']		= 'avia-target-insert';
			$this->config['shortcode'] 	= 'av_editlink';
			$this->config['modal_data'] = array('modal_class' => 'mediumscreen');
			$this->config['tooltip'] 	= __('Displays a post/page/product edit button.', 'avia_framework' );
			$this->config['drag-level'] = 3;
			$this->config['tinyMCE'] 	= array('disable' => "true");
			$this->config['preview'] 	= false;
		}


		/**
		 * Editor Element - this function defines the visual appearance of an element on the AviaBuilder Canvas
		 * Most common usage is to define some markup in the $params['innerHtml'] which is then inserted into the drag and drop container
		 * Less often used: $params['data'] to add data attributes, $params['class'] to modify the className
		 *
		 *
		 * @param array $params this array holds the default values for $content and $args.
		 * @return $params the return array usually holds an innerHtml key that holds item specific markup.
		 */
		function editor_element($params)
		{
			$params['innerHtml'] = "<img src='".$this->config['icon']."' title='".$this->config['name']."' />";
			$params['innerHtml'].= "<div class='avia-element-label'>".$this->config['name']."</div>";
			$params['content'] 	 = NULL; //remove to allow content elements
			return $params;
		}


		/**
		 * Popup Elements
		 *
		 * If this function is defined in a child class the element automatically gets an edit button, that, when pressed
		 * opens a modal window that allows to edit the element properties
		 *
		 * @return void
		 */
		function popup_elements()
		{
			$this->elements = array(
					
				array(
						"type" 	=> "tab_container", 'nodescription' => true
					),
					
				array(
							"type" 	=> "tab",
							"name"	=> __("Options",'avia_framework' ),
							'nodescription' => true
						),
						
					array(	"name" 	=> __("Label", 'avia_framework' ),
							"desc" 	=> __("This is the text that appears on your link or button.", 'avia_framework' ),
				            "id" 	=> "label",
				            "type" 	=> "input",
				            "std" => __("EDIT", 'avia_framework' )),
							
					array(	
							"name" 	=> __("Custom Font Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom color for your link or button text here.", 'avia_framework' ),
							"id" 	=> "font",
							"type" 	=> "colorpicker",
							"std" 	=> "#ffffff",
						),
						
					array(	
							"name" 	=> __("Button Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom color for your button here.", 'avia_framework' ),
							"id" 	=> "custom_bg",
							"type" 	=> "colorpicker",
							"std" 	=> "#202020",
						),
						
					array(	
							"name" 	=> __("Button Position", 'avia_framework' ),
							"desc" 	=> __("Select the icon position.", 'avia_framework' ),
							"id" 	=> "btnpos",
							"type" 	=> "select",
							"std" 	=> "left",
							"subtype" => array("Left"=>'left',"Center"=>'center',"Right"=>'right')
							),
				
					array(	
							"name" 	=> __("Button Function", 'avia_framework' ),
							"desc" 	=> __("Select whether you would like the button to redirect the page to the backend or open the backend edit screen in a modal window.", 'avia_framework' ),
							"id" 	=> "btnfunc",
							"type" 	=> "select",
							"std" 	=> "modal",
							"subtype" => array("Reidrect"=>'redirect',"Modal"=>'modal')
							),
							
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
						
					array(
						"type" 	=> "close_div",
						'nodescription' => true
					),	
				
				);
		}


		/**
		 * Frontend Shortcode Handler
		 *
		 * @param array $atts array of attributes
		 * @param string $content text within enclosing form of shortcode element
		 * @param string $shortcodename the shortcode found, when == callback name
		 * @return string $output returns the modified html string
		 */
		 
		function shortcode_handler($atts, $content = "", $shortcodename = "", $meta = "")
		{
			extract(shortcode_atts(array('label'=>'', 'font'=>'#ffffff', 'custom_bg'=>'#202020', 'btnpos'=>'', 'btnfunc'=>'modal'), $atts, $this->config['shortcode']));
			
			$meta['el_class'];
								
			if($btnfunc = 'modal'){$editurl .= get_edit_post_link().'?iframe=true';}else{$editurl .= get_edit_post_link();}
			$editurl = '<div class="avia-button-wrap avia-button-'.$atts['btnpos'].' avia-builder-el-25  el_after_av_editlink  avia-builder-el-last  "><a href="'.$editurl.'" class="avia-button  avia-icon_select-yes-left-icon avia-color-custom avia-size-small avia-position-'.$atts['btnpos'].'" style="background-color:'.$atts['custom_bg'].'; border-color:'.$atts['custom_bg'].'; color:'.$atts['font'].'; "><span class="avia_button_icon avia_button_icon_left" aria-hidden="true" data-av_icon="" data-av_iconfont="entypo-fontello"></span><span class="avia_iconbox_title">'.$atts['label'].'</span></a></div>';
		
			//html markup
			if (current_user_can( 'edit_post')){
					$output .= $editurl;
			}
			return $output;
		}
	}
}
